<?php
/*
Plugin Name: Calii slideshow
Plugin URI: http://calii.fr/wordpress/plugins/calii-slideshow/
Description: Placez ce code ou vous souhaitez voir apparaitre le slideshow : <code>if(function_exists("er_slideshow")) er_slideshow();  </code>
Version: 1.2b beta
Author: Fabien Thomas
Author URI: http://calii.fr/
*/


if (!defined('ABSPATH')) die("Aren't you supposed to come here via WP-Admin?");
 
add_action( 'admin_menu', 'er_slideshow_option' );

function er_slideshow_option(){
	$calii_slideshow_page=add_menu_page('Calii SlideShow', 'Calii SlideShow', 10, __FILE__, 'er_slideshow_setting');
	$calii_slideshow_page=add_submenu_page(__FILE__, 'Gestion des images', 'Images', 10, 'sub-page', 'er_slideshow_img');
  add_action( 'admin_head-'. $calii_slideshow_page, 'load_into_head' );
  
}

//----------------------------------- check database
//

$jquery = 'er_enable_jquery' ; 
$jquery_value = 'yes' ;
  if ( get_option($jquery) ) {
  } else { update_option($jquery, $jquery_value); }
  
$er_slideshow1_check = 'er_slideshow1-check' ;
$er_slideshow1_check_value = 'on';
 if ( get_option($er_slideshow1_check) ) {
  } else { update_option($er_slideshow1_check, $er_slideshow1_check_value); }

$er_slideshow2_check = 'er_slideshow2-check' ;
$er_slideshow2_check_value = 'on';
 if ( get_option($er_slideshow2_check) ) {
  } else { update_option($er_slideshow2_check, $er_slideshow2_check_value); }

$er_slideshow3_check = 'er_slideshow3-check' ;
$er_slideshow3_check_value = 'on';
 if ( get_option($er_slideshow3_check) ) {
  } else { update_option($er_slideshow3_check, $er_slideshow3_check_value); }

$er_slideshow4_check = 'er_slideshow4-check' ;
$er_slideshow4_check_value = 'on';
 if ( get_option($er_slideshow4_check) ) {
  } else { update_option($er_slideshow4_check, $er_slideshow4_check_value); }
  
$er_slideshow5_check = 'er_slideshow5-check' ;
$er_slideshow5_check_value = 'on';
 if ( get_option($er_slideshow5_check) ) {
  } else { update_option($er_slideshow5_check, $er_slideshow5_check_value); }
  
$er_effect = 'er_effect' ; 
$er_effect_value = 'scrollLeft' ;
  if ( get_option($er_effect) ) {
  } else { update_option($er_effect, $er_effect_value); }

$er_timout = 'er_timout' ; 
$er_timout_value = '2000' ;
  if ( get_option($er_timout) ) {
  } else { update_option($er_timout, $er_timout_value); }
  
$er_animation_speed = 'er_animation_speed' ; 
$er_animation_speed_value = '2000' ;
  if ( get_option($er_animation_speed) ) {
  } else { update_option($er_animation_speed, $er_animation_speed_value); }
  
$er_container_width = 'er_container_width' ; 
$er_container_width_value = '320' ;
  if ( get_option($er_container_width) ) {
  } else { update_option($er_container_width, $er_container_width_value); }
  
$er_container_height = 'er_container_height' ; 
$er_container_height_value = '250' ;
  if ( get_option($er_container_height) ) {
  } else { update_option($er_container_height, $er_container_height_value); }
  
$er_controlebox = 'er_controlebox' ; 
$er_controlebox_value = 'over' ;
  if ( get_option($er_controlebox) ) {
  } else { update_option($er_controlebox, $er_controlebox_value); }

$er_display_pager = 'er_display_pager' ; 
$er_display_pager_value = 'over' ;
  if ( get_option($er_display_pager) ) {
  } else { update_option($er_display_pager, $er_display_pager_value); }

$er_display_title = 'er_display_title' ; 
$er_display_title_value = 'on' ;
  if ( get_option($er_display_title) ) {
  } else { update_option($er_display_title, $er_display_title_value); }
 
$er_nav_color = 'er_nav_color' ; 
$er_nav_color_value = 'clear' ;
  if ( get_option($er_nav_color) ) {
  } else { update_option($er_nav_color, $er_nav_color_value); }

$er_slideshow1_title = 'er_slideshow1_title' ; 
$er_slideshow1_title_value = 'image 1' ;
  if ( get_option($er_slideshow1_title) ) {
  } else { update_option($er_slideshow1_title, $er_slideshow1_title_value); }
 
$er_slideshow2_title = 'er_slideshow2_title' ; 
$er_slideshow2_title_value = 'image 2' ;
  if ( get_option($er_slideshow2_title) ) {
  } else { update_option($er_slideshow2_title, $er_slideshow2_title_value); }

$er_slideshow3_title = 'er_slideshow3_title' ; 
$er_slideshow3_title_value = 'image 3' ;
  if ( get_option($er_slideshow3_title) ) {
  } else { update_option($er_slideshow3_title, $er_slideshow3_title_value); }

$er_slideshow4_title = 'er_slideshow4_title' ; 
$er_slideshow4_title_value = 'image 4' ;
  if ( get_option($er_slideshow4_title) ) {
  } else { update_option($er_slideshow4_title, $er_slideshow4_title_value); }

$er_slideshow5_title = 'er_slideshow5_title' ; 
$er_slideshow5_title_value = 'image 5' ;
  if ( get_option($er_slideshow5_title) ) {
  } else { update_option($er_slideshow5_title, $er_slideshow5_title_value); }
  
$er_slideshow1_link = 'er_slideshow1_link' ;
$er_slideshow1_link_value = 'http://calii.fr/wordpress-plugins-calii-slideshow' ;
  if ( get_option($er_slideshow1_link) ) {
  } else { update_option($er_slideshow1_link, $er_slideshow1_link_value); }
  
$er_slideshow2_link = 'er_slideshow2_link' ;
$er_slideshow2_link_value = 'http://calii.fr/wordpress-plugins-calii-slideshow' ;
  if ( get_option($er_slideshow2_link) ) {
  } else { update_option($er_slideshow2_link, $er_slideshow2_link_value); }
  
$er_slideshow3_link = 'er_slideshow3_link' ;
$er_slideshow3_link_value = 'http://calii.fr/wordpress-plugins-calii-slideshow' ;
  if ( get_option($er_slideshow3_link) ) {
  } else { update_option($er_slideshow3_link, $er_slideshow3_link_value); }
  
$er_slideshow4_link = 'er_slideshow4_link' ;
$er_slideshow4_link_value = 'http://calii.fr/wordpress-plugins-calii-slideshow' ;
  if ( get_option($er_slideshow4_link) ) {
  } else { update_option($er_slideshow4_link, $er_slideshow4_link_value); }
  
$er_slideshow5_link = 'er_slideshow5_link' ; 
$er_slideshow5_link_value = 'http://calii.fr/wordpress-plugins-calii-slideshow';
  if ( get_option($er_slideshow5_link) ) {
  } else { update_option($er_slideshow5_link, $er_slideshow5_link_value); }
  
$er_slideshow1_src = 'er_slideshow1_src' ; 
$er_slideshow1_src_value = '/wp-content/plugins/calii_slideshow/slides/01.jpg' ;
  if ( get_option($er_slideshow1_src) ) {
  } else { update_option($er_slideshow1_src, $er_slideshow1_src_value); }
  
$er_slideshow2_src = 'er_slideshow2_src' ; 
$er_slideshow2_src_value = '/wp-content/plugins/calii_slideshow/slides/02.jpg' ;
  if ( get_option($er_slideshow2_src) ) {
  } else { update_option($er_slideshow2_src, $er_slideshow2_src_value); }

$er_slideshow3_src = 'er_slideshow3_src' ; 
$er_slideshow3_src_value = '/wp-content/plugins/calii_slideshow/slides/03.jpg' ;
  if ( get_option($er_slideshow3_src) ) {
  } else { update_option($er_slideshow3_src, $er_slideshow3_src_value); }

$er_slideshow4_src = 'er_slideshow4_src' ; 
$er_slideshow4_src_value = '/wp-content/plugins/calii_slideshow/slides/04.jpg' ;
  if ( get_option($er_slideshow4_src) ) {
  } else { update_option($er_slideshow4_src, $er_slideshow4_src_value); }
 
$er_slideshow5_src = 'er_slideshow5_src' ; 
$er_slideshow5_src_value = '/wp-content/plugins/calii_slideshow/slides/05.jpg' ;
  if ( get_option($er_slideshow5_src) ) {
  } else { update_option($er_slideshow5_src, $er_slideshow5_src_value); }
  
$er_credits = 'er_credits' ; 
$er_credits_value = 'on' ;
  if ( get_option($er_credits) ) {
  } else { update_option($er_credits, $er_credits_value); }


//----------------------------------- Script et CSS requis pour l'admin du plugin
//

function load_into_head() {
$er_slideshow_path =  get_bloginfo('wpurl')."/wp-content/plugins/calii_slideshow/"; 
?>

<script type="text/javascript" src="<?php echo $er_slideshow_path ?>js/jquery.js"></script>

<script type="text/javascript" src="<?php echo $er_slideshow_path ?>js/tip.js"></script>

<script type="text/javascript">
	
$(document).ready(function(){
	$(".help").tooltip({cssClass:"tooltip-red", duration:1000, xOffset:20, yOffset:-30, fadeDuration: 400});
	
	$('#snippet pre code').each(function() {
        eval($(this).text());
    });


});

</script>

<style type="text/css">
	@import url(<?php echo $er_slideshow_path ?>admin.css);
</style>

<?php }



//----------------------------------- Page admin du plugin
//

function er_slideshow_setting() { ?>
<div class="wrap">
<h2>Calii SlideShow</h2>
<h3>Options et r&eacute;glages</h3>
<form method="post" action="options.php">
<?php wp_nonce_field('update-options'); ?>

    <table>
	<tr>
        <td width="50%" valign="top">
        	<table  class="form-table">
        		<tr>
                <td valign="top" width="40%">
                <label for="er_enable_jquery">Activer Jquery</label></td><td valign="top">
                <select name="er_enable_jquery" id="er_enable_jquery">
                <option value="yes"<?php selected('yes', get_option('er_enable_jquery')); ?>>oui</option>
                <option value="no"<?php selected('no', get_option('er_enable_jquery')); ?>>Non</option>
                </select>
                <span><a class="help" href="#" title="Permet d'&eacute;viter les conflits de scripts " id="aeffect">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                <td valign="top" width="40%">
                <label for="er_effect">Effet de transition</label></td><td valign="top">
                <select name="er_effect" id="er_effect">
                <option value="fade"<?php selected('fade', get_option('er_effect')); ?>>fade</option>
                <option value="scrollLeft"<?php selected('scrollLeft', get_option('er_effect')); ?>>scrollLeft</option>
                <option value="scrollDown"<?php selected('scrollDown', get_option('er_effect')); ?>>scrollDown</option>
                <option value="scrollUp"<?php selected('scrollUp', get_option('er_effect')); ?>>scrollUp</option>
                <option value="scrollRight"<?php selected('scrollRight', get_option('er_effect')); ?>>scrollRight</option>
                <option value="cover"<?php selected('cover', get_option('er_effect')); ?>>cover</option>
                <option value="fadeZoom"<?php selected('fadeZoom', get_option('er_effect')); ?>>fadeZoom</option>
                <option value="slideX"<?php selected('slideX', get_option('er_effect')); ?>>slideX</option>
                </select>
                <span><a class="help" href="#" title="Type de transition du slideshow" id="aeffect">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                <td valign="top" width="40%">
                    <label for="er_timout">Temps de pause</label></td><td valign="top">
                    <select name="er_timout" id="er_timout">
                    <option value="2000"<?php selected('2000', get_option('er_timout')); ?>>Tr&egrave;s Court</option>
                    <option value="3000"<?php selected('3000', get_option('er_timout')); ?>>Court</option>
                    <option value="4000"<?php selected('4000', get_option('er_timout')); ?>>Normal</option>
                    <option value="5000"<?php selected('5000', get_option('er_timout')); ?>>Long</option>
                    <option value="6000"<?php selected('6000', get_option('er_timout')); ?>>Tr&egrave;s long</option>
                     </select>
                <span><a class="help" href="#" title="Temps de pause entre les transitions" id="apause">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                <td valign="top" width="40%">
                    <label for="er_animation_speed">Vitesse de transition</label></td><td valign="top">
                    <select name="er_animation_speed" id="er_animation_speed">
                    <option value="500"<?php selected('500', get_option('er_animation_speed')); ?>> Tr&egrave;s rapide</option>
                    <option value="800"<?php selected('800', get_option('er_animation_speed')); ?>>Rapide</option>
                    <option value="1000"<?php selected('1000', get_option('er_animation_speed')); ?>>Normal</option>
                    <option value="2000"<?php selected('2000', get_option('er_animation_speed')); ?>>Long</option>
                    <option value="3000"<?php selected('3000', get_option('er_animation_speed')); ?>>Tr&egrave;s long</option>
                     </select>
                <span><a class="help" href="#" title="Vitesse des transitions" id="aspeed">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                <td valign="top" width="40%">
                <label for="er_container_width">Largeur du slideshow</label></td><td>
                <input name="er_container_width" id="er_container_width" size="4" value="<?php echo get_option('er_container_width'); ?>" maxlength="4" />
                <span ><a class="help" href="#" title="Largeur en pixel (px) du slideshow" id="awidth">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                <td valign="top" width="50%">
                <label for="er_container_height">Hauteur du slideshow</label></td><td>
                <input name="er_container_height" id="er_container_height" size="4" value="<?php echo get_option('er_container_height'); ?>" maxlength="4" />
                <span ><a class="help" href="#" title="Hauteur en pixel (px) du slideshow" rel="#infoheight" id="aheight">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                    <td valign="top" width="40%">
                        <label for="er_controlebox">Navigation</label></td>
                    <td valign="top">
                        <select name="er_controlebox" id="er_controlebox">
                        <option value="off"<?php selected('off', get_option('er_controlebox')); ?>>Masquer</option>
                        <option value="on"<?php selected('on', get_option('er_controlebox')); ?>>Afficher</option>
                        <option value="over"<?php selected('over', get_option('er_controlebox')); ?>>MouseHover</option>
                         </select>
                <span><a class="help" href="#" title="Option d'affichage de la navigation" id="acontrol">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                    <td valign="top" width="40%"><label for="er_display_pager"> Pagination : </label></td>
                    <td valign="top"><select name="er_display_pager" id="er_display_pager">
                        <option value="off"<?php selected('off', get_option('er_display_pager')); ?>>Masquer</option>
                        <option value="on"<?php selected('on', get_option('er_display_pager')); ?>>Afficher</option>
                        <option value="over"<?php selected('over', get_option('er_display_pager')); ?>>MouseHover</option>
                         </select>
                <span><a class="help" href="#" title="Options d'affichage de la pagination" id="apager">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                    <td valign="top" width="40%"><label for="er_display_title">Titres : </label></td>
                    <td valign="top"><select name="er_display_title" id="er_controlebox">
                        <option value="off"<?php selected('off', get_option('er_display_title')); ?>>Masquer</option>
                        <option value="on"<?php selected('on', get_option('er_display_title')); ?>>Afficher</option>
                        <option value="over"<?php selected('over', get_option('er_display_title')); ?>>MouseHover</option>
                         </select>
                <span><a class="help" href="#" title="Options d'affichage des titres" id="atitle">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                    <td valign="top" width="40%"><label for="er_nav_color">Couleur des boutons : </label></td>
                    <td valign="top"><select name="er_nav_color" id="er_nav_color">
                        <option value="dark"<?php selected('dark', get_option('er_nav_color')); ?>>Noir</option>
                        <option value="clear"<?php selected('clear', get_option('er_nav_color')); ?>>Blanc</option>
                         </select>
                <span><a class="help" href="#" title="Couleur des boutons, noir ou blanc" id="acolor">[ ? ]</a></span>
                </td>
                </tr>
                <tr>
                    <td valign="top" width="40%"><label  for="er_credits">Afficher le lien Calii</label></td>
                    <td valign="top"><select name="er_credits" id="er_credits">
                        <option value="on"<?php selected('on', get_option('er_credits')); ?>>Oui</option>
                        <option value="off"<?php selected('off', get_option('er_credits')); ?>>Non</option>
                         </select>
                <span><a class="help" href="#" title="Afficher le lien vers le site du d&eacute;veloppeur du plugin. Merci d'avance">[ ? ]</a></span>
                </td>
                </tr>
        	</table>
        </td>
            <td width="50%" valign="top">
            	<table class="info">
                	<tr>
                    	<td>
                    		<div id="infowrapper">
                    			<div id="infos">
       					 
       	<h3>Int&eacute;gration au th&egrave;me</h3>
        <p>
        	En attendant la sortie d'un widget facilitant l'int&eacute;gration &agrave; votre blog, vous devez utiliser le bout de code suivant :<br />
            <div id="snippet">
            <pre><code>&#60;?php&nbsp;if (function_exists('er_slideshow')) : er_slideshow(); endif;&nbsp;?&#62;</code></pre>
            </div>
        </p>
        <p>
        	Il suffit de placer ce bout de code entre 2 balises php n'importe ou dans votre th&egrave;me, pensez &agrave; r&eacute;gler vos dimensions
        </p>
<h3>Encouragez le d&eacute;veloppement !</h3>
<p>
D&eacute;velopper ce plugin aura n&eacute;cessit&eacute; de nombreuses heures de travail acharn&eacute;es, souvent la nuit, et la nuit pour continuer &agrave; d&eacute;velopper et/ou am&eacute;liorer nos plugins, nous avons besoin de caf&eacute;, entre autre....</p>
<p>Donc si vous voulez, vous pouvez faire un don, peu importe le montant, ce qui nous encouragera vraiment &agrave; garder les yeux ouverts et les neurones en action !
</p>
<p>Merci d'avance ;)</p>
<form id="donationform" action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="hidden" name="hosted_button_id" value="1408598">
<input type="image" src="https://www.paypal.com/fr_FR/FR/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="">
<img alt="" border="0" src="https://www.paypal.com/fr_FR/i/scr/pixel.gif" width="1" height="1">
</form>
<small style="display:block; textalign:center;">calii SlideShow est bas&eacute; sur <a href="http://www.malsup.com/jquery/cycle/">JQuery Cycle Plugin</a> | <a href="http://creativecommons.org/licenses/by-nc/2.0/fr/">License d'utilisation</a> </small>
</div>

                       			</div>
                      		</div> 
                        </td>
                    </tr>
                </table>
           </td>
    </tr>
</table>

<input type="hidden" name="action" value="update" />
<input type="hidden" name="page_options" value="er_enable_jquery,er_credits,er_nav_color,er_display_title,er_display_pager,er_controlebox,er_container_height,er_container_width,er_animation_speed,er_timout,er_effect" />

<p class="submit">
<input type="submit" name="Submit" value="Mettre &agrave; jour &raquo;" />
</p>

</td></tr>
</table>
</form>
</div>

<?php }


//----------------------------------- Gestion des slides
//

function er_slideshow_img() { ?>
<div class="wrap">
<h2>Calii SlideShow</h2>

<form method="post" action="options.php">
<?php wp_nonce_field('update-options'); ?>

<h3>Gestion des images</h3>
<table class="form-table">
	<tr>
    	<td width="10%"><a href="<?php echo get_option('er_slideshow1_src'); ?>" class="thickbox"><img src="<?php echo get_option('er_slideshow1_src'); ?>" height="100" width="150" title="<?php echo get_option('er_slideshow1_title'); ?>" /></a></td>
        <td width="90%">
        <table class="subform-table">
        	<tr>
            	<td width="20%">
                	<label for="er_slideshow1_title">Titre:</label></td>
                <td width="50%">
                	<input name="er_slideshow1_title" id="er_slideshow1_title" value="<?php echo get_option('er_slideshow1_title'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">Activer</td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow1_link">Lien de destination :</label></td>
                <td width="50%">
                	<input name="er_slideshow1_link" id="er_slideshow1_link" value="<?php echo get_option('er_slideshow1_link'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">
                    <select id="er_slideshow1-check" name="er_slideshow1-check">
                    	<option value="on" <?php selected('on', get_option('er_slideshow1-check')); ?>>Oui</option>
                        <option value="off" <?php selected('off', get_option('er_slideshow1-check')); ?>>Non</option>
                    </select>
               </td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow1_src">Source de l'image:</label></td>
                <td width="50%">
                	<input name="er_slideshow1_src" id="er_slideshow1_src" value="<?php echo get_option('er_slideshow1_src'); ?>" size="40"></input>
                </td>
                <td width="10%"></td>
        	</tr>
        </table>
	</td>
    </tr>
    <tr>
    	<td width="10%"><a href="<?php echo get_option('er_slideshow2_src'); ?>" class="thickbox"><img src="<?php echo get_option('er_slideshow2_src'); ?>" height="100" width="150" title="<?php echo get_option('er_slideshow2_title'); ?>" /></a></td>
        <td width="90%">
        <table class="subform-table">
        	<tr>
            	<td width="20%">
                	<label for="er_slideshow2_title">Titre:</label></td>
                <td width="50%">
                	<input name="er_slideshow2_title" id="er_slideshow2_title" value="<?php echo get_option('er_slideshow2_title'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">Activer</td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow2_link">Lien de destination :</label></td>
                <td width="50%">
                	<input name="er_slideshow2_link" id="er_slideshow2_link" value="<?php echo get_option('er_slideshow2_link'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">
                    <select id="er_slideshow2-check" name="er_slideshow2-check">
                    	<option value="on" <?php selected('on', get_option('er_slideshow2-check')); ?>>Oui</option>
                        <option value="off" <?php selected('off', get_option('er_slideshow2-check')); ?>>Non</option>
                    </select>
               </td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow2_src">Source de l'image:</label></td>
                <td width="50%">
                	<input name="er_slideshow2_src" id="er_slideshow2_src" value="<?php echo get_option('er_slideshow2_src'); ?>" size="40"></input>
                </td>
                <td width="10%"></td>
        	</tr>
        </table>
	</td>
    </tr>
    <tr>
    	<td width="10%"><a href="<?php echo get_option('er_slideshow3_src'); ?>" class="thickbox"><img src="<?php echo get_option('er_slideshow3_src'); ?>" height="100" width="150" title="<?php echo get_option('er_slideshow3_title'); ?>" /></a></td>
        <td width="90%">
        <table class="subform-table">
        	<tr>
            	<td width="20%">
                	<label for="er_slideshow3_title">Titre:</label></td>
                <td width="50%">
                	<input name="er_slideshow3_title" id="er_slideshow3_title" value="<?php echo get_option('er_slideshow3_title'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">Activer</td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow3_link">Lien de destination :</label></td>
                <td width="50%">
                	<input name="er_slideshow3_link" id="er_slideshow3_link" value="<?php echo get_option('er_slideshow3_link'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">
                    <select id="er_slideshow3-check" name="er_slideshow3-check">
                    	<option value="on" <?php selected('on', get_option('er_slideshow3-check')); ?>>Oui</option>
                        <option value="off" <?php selected('off', get_option('er_slideshow3-check')); ?>>Non</option>
                    </select>
               </td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow3_src">Source de l'image:</label></td>
                <td width="50%">
                	<input name="er_slideshow3_src" id="er_slideshow3_src" value="<?php echo get_option('er_slideshow3_src'); ?>" size="40"></input>
                </td>
                <td width="10%"></td>
        	</tr>
        </table>
	</td>
    </tr>
    <tr>
    	<td width="10%"><a href="<?php echo get_option('er_slideshow4_src'); ?>" class="thickbox"><img src="<?php echo get_option('er_slideshow4_src'); ?>" height="100" width="150" title="<?php echo get_option('er_slideshow4_title'); ?>" /></a></td>
        <td width="90%">
        <table class="subform-table">
        	<tr>
            	<td width="20%">
                	<label for="er_slideshow4_title">Titre:</label></td>
                <td width="50%">
                	<input name="er_slideshow4_title" id="er_slideshow4_title" value="<?php echo get_option('er_slideshow4_title'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">Activer</td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow4_link">Lien de destination :</label></td>
                <td width="50%">
                	<input name="er_slideshow4_link" id="er_slideshow4_link" value="<?php echo get_option('er_slideshow4_link'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">
                    <select id="er_slideshow4-check" name="er_slideshow4-check">
                    	<option value="on" <?php selected('on', get_option('er_slideshow4-check')); ?>>Oui</option>
                        <option value="off" <?php selected('off', get_option('er_slideshow4-check')); ?>>Non</option>
                    </select>
               </td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow4_src">Source de l'image:</label></td>
                <td width="50%">
                	<input name="er_slideshow4_src" id="er_slideshow4_src" value="<?php echo get_option('er_slideshow4_src'); ?>" size="40"></input>
                </td>
                <td width="10%"></td>
        	</tr>
        </table>
	</td>
    </tr>
    <tr>
    	<td width="10%"><a href="<?php echo get_option('er_slideshow5_src'); ?>" class="thickbox"><img src="<?php echo get_option('er_slideshow5_src'); ?>" height="100" width="150" title="<?php echo get_option('er_slideshow5_title'); ?>" /></a></td>
        <td width="90%">
        <table class="subform-table">
        	<tr>
            	<td width="20%">
                	<label for="er_slideshow5_title">Titre:</label></td>
                <td width="50%">
                	<input name="er_slideshow5_title" id="er_slideshow5_title" value="<?php echo get_option('er_slideshow5_title'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">Activer</td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow5_link">Lien de destination :</label></td>
                <td width="50%">
                	<input name="er_slideshow5_link" id="er_slideshow5_link" value="<?php echo get_option('er_slideshow5_link'); ?>" size="40"></input>
                </td>
                <td width="10%" class="er_active">
                    <select id="er_slideshow5-check" name="er_slideshow5-check">
                    	<option value="on" <?php selected('on', get_option('er_slideshow5-check')); ?>>Oui</option>
                        <option value="off" <?php selected('off', get_option('er_slideshow5-check')); ?>>Non</option>
                    </select>
               </td>
        	</tr>
            <tr>
            	<td width="20%">
                	<label for="er_slideshow5_src">Source de l'image:</label></td>
                <td width="50%">
                	<input name="er_slideshow5_src" id="er_slideshow5_src" value="<?php echo get_option('er_slideshow5_src'); ?>" size="40"></input>
                </td>
                <td width="10%"></td>
        	</tr>
        </table>
	</td>
    </tr>
</table>

<input type="hidden" name="action" value="update" />
<input type="hidden" name="page_options" value="er_slideshow5_src,er_slideshow5-check,er_slideshow5_title,er_slideshow5_link,er_slideshow4_src,er_slideshow4-check,er_slideshow4_title,er_slideshow4_link,er_slideshow3_src,er_slideshow3-check,er_slideshow3_title,er_slideshow3_link,er_slideshow2_src,er_slideshow2-check,er_slideshow2_title,er_slideshow2_link,er_slideshow1_src,er_slideshow1-check,er_slideshow1_title,er_slideshow1_link" />

<p class="submit">
<input type="submit" name="Submit" value="Mettre &agrave; jour &raquo;" />
</p>

</td>
</tr>
</table>
</form>
</div>

<?php }



//----------------------------------- Futur emplacement de la page des uploads
//

function er_slideshow_Uploads() { ?>


<?php } 



//----------------------------------- Slideshow
//

function er_slideshow_scripts() {
	
    $er_slideshow_path =  get_bloginfo('wpurl')."/wp-content/plugins/calii_slideshow/";
	
	$en_jquery=get_option('er_enable_jquery');
	if ($en_jquery == 'yes') { 
	$er_slideshow_script ="<script type='text/javascript' src='".$er_slideshow_path."js/jquery.js'></script>"; }

	
	$er_slideshow_script .= "
    <script type='text/javascript' src='".$er_slideshow_path."js/cycle.js'></script>

	<script type='text/javascript'>
	$(function() {
  		$('#er_slideshow').cycle({ 
    		fx: '".get_option('er_effect')."', 
    		timeout: ".get_option('er_timout').",
			speed:   ".get_option('er_animation_speed').",
			pager:  '#er_pagination',
			prev:   '#prevButton span',
			next:   '#nextButton span',
			pagerEvent: 'mouseover',
			pauseOnPagerHover: true,
			slideExpr: 'a',
			pause:  1 
		});
		
		$('#pauseButton span').toggle(
				function () {
					$('#er_slideshow').cycle('pause');
					$('#pauseButton span').toggle();
				},
				function () {
					$('#er_slideshow').cycle('resume');
					$('#pauseButton span').toggle();
		});
	});
	</script>\n";
	
	// titres
	
	$fullheight=get_option('er_container_height');
	$titleheight=(35);
	$fullwidth=get_option('er_container_width');
	$margetop=$fullheight-$titleheight;
	$er_slideshow_script.="<style type='text/css'> span.er_title { top:".$margetop."px; width:".$fullwidth."px; } </style>";
	
	
	$er_title=get_option('er_display_title');
	if ($er_title == 'off') { 
	
	$er_slideshow_script.="<style type='text/css'> span.er_title { display:none; } </style>";  
	
	} else if ($er_title == 'on') { 
	
	$er_slideshow_script.="<style type='text/css'> span.er_title { display:block; } </style>";
	
	} else if ($er_title == 'over') {"; ";
	
	$er_slideshow_script.="
	<script type='text/javascript'>
	$(document).ready(function(){
		$('span.er_title').hide();
		$('#er_slideshow_wrapper').hover(
			function() { $('span.er_title').fadeIn();
		},
			function() { $('span.er_title').fadeOut();
		});

	});
	
	
	</script>
	\n"; }
	
	// control box

	$er_controler=get_option('er_controlebox');
	if ($er_controler == 'off') { 
	
	$er_slideshow_script.="<style type='text/css'> ul#er_controler { display:none; } </style>";  
	
	} else if ($er_controler == 'on') { 
	
	$er_slideshow_script.="<style type='text/css'> ul#er_controler { display:block; } </style>";
	
	} else if ($er_controler == 'over') {"; ";
	
	$er_slideshow_script.="
	<script type='text/javascript'>
	$(document).ready(function(){
		$('#er_controler').hide();
		$('#er_slideshow_wrapper').hover(
			function() { $('#er_controler').fadeIn();
		},
			function() { $('#er_controler').fadeOut();
		});
	});

	</script>
	\n"; }
	
	// pagination
	
	$er_pager=get_option('er_display_pager');
	if ($er_pager == 'off') { 
	
	$er_slideshow_script.="<style type='text/css'> div#er_pagination { display:none; } </style>";  
	
	} else if ($er_pager == 'on') { 
	
	$er_slideshow_script.="<style type='text/css'> div#er_pagination { display:block; } </style>";
	
	} else if ($er_pager == 'over') {"; ";
	
	$er_slideshow_script.="
	<script type='text/javascript'>
	$(document).ready(function(){
		$('#er_pagination').hide();
		$('#er_slideshow_wrapper').hover(
			function() { $('#er_pagination').fadeIn();
		},
			function() { $('#er_pagination').fadeOut();
		});

	});
	
	
	</script>
	\n"; }

	
	echo($er_slideshow_script);
}


add_action('wp_footer', 'er_slideshow_scripts');

add_action('wp_head', 'er_slideshow_styles' );
function er_slideshow_styles() {
	$height=get_option('er_container_height');
	$width=get_option('er_container_width');
	$er_slideshow_path =  get_bloginfo('wpurl')."/wp-content/plugins/calii_slideshow/";
	$er_slideshow_dim="
	<style type='text/css'>
		.er_title {
		position: absolute;
		left:0px;
		z-index: 290;
		height: 35px;
		line-height:35px;
		font-size:16px;
		color:#fff;
		display: block;
		text-align:center;
		background:#000;
		filter:alpha(opacity=80);
		-moz-opacity: 0.8;
		opacity: .8;
		}
		
		ul#er_controler {
		position:absolute;
		top:5px;
		left:5px;
		z-index:10;
		}
		
		ul#er_controler li {
		display:block;
		float:left;
		padding:0;
		height:16px;
		width:16px;
		overflow:hidden;
		margin-right:1px;
		border:none;
		}
		
		ul#er_controler li span {
		display:block;
		height:16px;
		width:16px;
		text-indent:-999px;
		cursor:pointer;
		}
		
		li.clear span, .clear a {
		color:#333;
		background-position: top left;
		}

		li.dark span, .dark a {
		color:#fff;
		background-position: bottom left!important;
		}
		
		span#prev {
		background:url(".$er_slideshow_path."img/er_prev.png) no-repeat;
		}
		
		span#pause {
		background:url(".$er_slideshow_path."img/er_plpa.png) no-repeat;
		background-position: top right!important;
		}
		
		li.dark span#pause {
		background:url(".$er_slideshow_path."img/er_plpa.png) no-repeat;
		background-position: bottom right!important;
		}
		
		span#play {
		background:url(".$er_slideshow_path."img/er_plpa.png) no-repeat;
		}
		
		span#next {
		background:url(".$er_slideshow_path."img/er_next.png) no-repeat;
		}
		
		div#er_pagination {
	position:absolute;
	top:5px;
	right:5px;
	z-index:10;
	}

div#er_pagination a {
	display:block;
	text-align:center;
	float:left;
	height:16px;
	width:16px;
	margin-left:1px;
	font-size:10px;
	line-height: 16px;
	text-decoration:none;
	background:url(".$er_slideshow_path."img/er_pagination.png) no-repeat;
	}
		
		.er_title a {
		display: block;
		text-decoration: none;
		}
		
		small#er_credits {
			position: absolute;
			bottom: 5px;
			right:10px;
			height: 24px;
			width:32px;
			z-index:500;
		}
		
		small#er_credits a {
			display: block;
			height: 24px;
			width:32px;
			text-indent:-9999px;
			background: url(".$er_slideshow_path."img/er_cred.png) 0 0 no-repeat;
			}
			
		small#er_credits a:hover {
			background-position: bottom left;
			}

		* { margin:0; padding:0;}
		a img {border: none;}
		.pics { height: ".$height."px; width:".$width."px; overflow: hidden}
		.pics div {height: ".$height."px; width:".$width."px; top:0; left:0;}
		#er_slideshow_wrapper {position:relative; height: ".$height."px; width:".$width."px; overflow: hidden}
	</style>
	";
	
	echo($er_slideshow_dim);
}
function er_slideshow() { 
$navcolor=get_option('er_nav_color'); ?>

<div id="er_slideshow_wrapper">
	
	<ul id="er_controler" class="ul-<?php echo $navcolor ?>">
		<li id="prevButton" class="<?php echo $navcolor ?>"><span id="prev">Prev</span></li>
		<li id="pauseButton" class="<?php echo $navcolor ?>"><span id="pause">Pause</span><span id="play" style="display:none">Play</span></li>
		<li id="nextButton" class="<?php echo $navcolor ?>"><span id="next">Next</span></li>
	</ul>
	
	<div id="er_pagination" class="<?php echo $navcolor ?>"></div>
	
	<div id="er_slideshow" class="pics">
	
		<?php $li01=get_option('er_slideshow1-check');
		if ($li01 =='on') { ?>
		<div>
			<a href="<?php echo get_option('er_slideshow1_link'); ?>" title="<?php echo get_option('er_slideshow1_title'); ?>">
				<img src="<?php echo get_option('er_slideshow1_src'); ?>" height="<?php echo get_option('er_container_height'); ?>" width="<?php echo get_option('er_container_width'); ?>" title="<?php echo get_option('er_slideshow1_title'); ?>" alt="<?php echo get_option('er_slideshow1_title'); ?>" />
				<span class="er_title">
					<?php echo get_option('er_slideshow1_title'); ?>
				</span>
			</a>
		</div>
		<?php } ?>
		
		<?php $li02=get_option('er_slideshow2-check');
		if ($li02 =='on') { ?>
		<div>
			<a href="<?php echo get_option('er_slideshow2_link'); ?>" title="<?php echo get_option('er_slideshow2_title'); ?>">
				<img src="<?php echo get_option('er_slideshow2_src'); ?>" height="<?php echo get_option('er_container_height'); ?>" width="<?php echo get_option('er_container_width'); ?>" title="<?php echo get_option('er_slideshow2_title'); ?>" alt="<?php echo get_option('er_slideshow2_title'); ?>" />
				<span class="er_title">
					<?php echo get_option('er_slideshow2_title'); ?>
				</span>
			</a>
		</div>
		<?php } ?>
		
		<?php $li03=get_option('er_slideshow3-check');
		if ($li03 =='on') { ?>
		<div>
			<a href="<?php echo get_option('er_slideshow3_link'); ?>" title="<?php echo get_option('er_slideshow3_title'); ?>">
				<img src="<?php echo get_option('er_slideshow3_src'); ?>" height="<?php echo get_option('er_container_height'); ?>" width="<?php echo get_option('er_container_width'); ?>" title="<?php echo get_option('er_slideshow3_title'); ?>" alt="<?php echo get_option('er_slideshow3_title'); ?>" />
				<span class="er_title">
					<?php echo get_option('er_slideshow3_title'); ?>
				</span>
			</a>
		</div>
		<?php } ?>
		
		<?php $li04=get_option('er_slideshow4-check');
		if ($li04 =='on') { ?>
		<div>
			<a href="<?php echo get_option('er_slideshow4_link'); ?>" title="<?php echo get_option('er_slideshow4_title'); ?>">
				<img src="<?php echo get_option('er_slideshow4_src'); ?>" height="<?php echo get_option('er_container_height'); ?>" width="<?php echo get_option('er_container_width'); ?>" title="<?php echo get_option('er_slideshow4_title'); ?>" alt="<?php echo get_option('er_slideshow4_title'); ?>" />
				<span class="er_title">
					<?php echo get_option('er_slideshow4_title'); ?>
				</span>
			</a>
		</div>
		<?php } ?>
		
		<?php $li05=get_option('er_slideshow5-check');
		if ($li05 =='on') { ?>
		<div>
			<a href="<?php echo get_option('er_slideshow5_link'); ?>" title="<?php echo get_option('er_slideshow5_title'); ?>">
				<img src="<?php echo get_option('er_slideshow5_src'); ?>" height="<?php echo get_option('er_container_height'); ?>" width="<?php echo get_option('er_container_width'); ?>" title="<?php echo get_option('er_slideshow5_title'); ?>" alt="<?php echo get_option('er_slideshow5_title'); ?>" />
				<span class="er_title">
					<?php echo get_option('er_slideshow5_title'); ?>
				</span>
			</a>
		</div>
		<?php } ?>
		
	</div>
	 <?php $copyright=get_option('er_credits');
			if ($copyright =='on') { ?> 
    	<small id="er_credits"><a href="http://calii.fr/wordpress-plugins-calii-slideshow" title="Calii SlideShow, plugin de slideshow pour wordpress par calii">plugin de slideshow pour wordpress par calii</a></small>
    <?php } ?>
</div>  
<?php } ?>